import org.serviio.library.metadata.*
import org.serviio.library.online.*

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * ReutersCom content URL extractor plugin v1.0 
 *  
 * @author Tyler Raulin
 * 
 * Jim Rome - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=6296737
 * Bill Simmons - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=2864045
 * ESPN Radio Daily - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=2090484
 * PTI - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=2406595
 * Around The Horn - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=2839445
 * Dan Le Batard - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=6962629
 * Scott Van Pelt - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=3028618
 * Outside The Lines - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=7128085
 * Tony Kornheiser - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=5543849
 * Jalen Rose - http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=6907276
 *
 */
class ReutersCom extends FeedItemUrlExtractor {
    
    final VALID_FEED_URL = 'http://espn.go.com/espnradio/feeds/rss/podcast.*'

    String getExtractorName() {
        return getClass().getName()
    }
    
    boolean extractorMatches(URL feedUrl) {
        return feedUrl ==~ VALID_FEED_URL
    }
    
    ContentURLContainer extractUrl(Map links, PreferredQuality requestedQuality) {
        def linkUrl = links.default
        return new ContentURLContainer(fileType: MediaFileType.AUDIO, contentUrl: linkUrl)
    }
    
    static void main(args) {
        // this is just to test
        ReutersCom extractor = new ReutersCom()

        assert extractor.extractorMatches( new URL("http://espn.go.com/espnradio/feeds/rss/podcast.xml?id=2406595") ) 
        assert !extractor.extractorMatches( new URL("http://google.com/feeds/api/standardfeeds/top_rated?time=today") ) 

        Map links = ['default': new URL('http://c.espnradio.com/s:5L8r1/audio/816399/pti_2011-12-09-183139.48.mp3')] 
        ContentURLContainer result = extractor.extractUrl(links, PreferredQuality.MEDIUM)
        println "Result: $result"
    }    
}